/***********************************************************************
*           See Accompanying licence file QSAS_licence                 *
***********************************************************************/


/* Global constants used by qie Free Time Format Routines collected here
* for convenience. See also qie.h and qie_ft.c
*/

#ifndef _QIE_FT_  
#define _QIE_FT_

/* c++ compliance... */

  #ifdef   __cplusplus
  extern "C" {
  #endif

#include "qie.h"

/* global array needed */

const double time_2_msecs_factors[N_FT_TIME_STRINGS] =    	/*SJS re FT*/
{
	 3600000,	/* msecs in HH */
	   60000,	/* MI */
	    1000,	/* S  */
	       1,	/* MC */
	86400000,	/* d : will be mult by 10^-[field_width] */
	 3600000,	/* h : ditto, etc. */
	   60000,	/* m */
	    1000,	/* s */
	       1	/* c */
};



const char *key_time_str[] = {"H","MI","S","MC","d","h","m","s","c"};
const char *rpt_time_chr[] = {"H", "I","S", "C","d","h","m","s","c"};

/* daytab: number of days in month for normal and leap years 
**         index 1 is Jan 
*/

int qie_days_in_month[2][13] = {
  { 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 },
  { 0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 }
};

static const char *monthnames[13] ={ 
 "", "JAN", "FEB", "MAR", "APR", "MAY",
 "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" };  
/* As special case, if none of the above are found, routine tries "JLY" */


  #ifdef   __cplusplus
  }
  #endif

#endif
