/***********************************************************************
*           See Accompanying licence file QSAS_licence                 *
***********************************************************************/


/* ensure cdf.h is included before declaractions dependent on CDF types */

#if !defined(___cdf_h___)
#include <cdf.h>
#endif

/* c++ compliance... */

  #ifdef   __cplusplus
  extern "C" {
  #endif


/* **************************************************************************
** 
** Function Prototypes
**
** ************************************************************************* 
*/



long QiTestStructure(QiCDFContents *QiSCDF); /* ptr to structure of file contents */

/**********************************/

 long QiWriteContents (QiCDFContents *QiSCDF, /* ptr to file contents struct */
                       QiOptions *QiSOpt);  /* ptr to options struct */ 

/**********************************/

long QiWriteGlobals (QiCDFContents *QiSCDF); /* ptr to structure of file contents */

/**********************************/

long QiWriteVariable (QiCDFContents *QiSCDF, /* ptr to structure of file contents */ 
                      long n);               /* index of variable in struct */

/**********************************/
		    
void QiEnsureVariable ( QiCDFContents *QiSCDF, /* ptr to structure of file contents */
                       long n);                /* index of variable in struct */

/**********************************/


 long QiWriteVarAttrs( QiCDFContents *QiSCDF, /* ptr to structure of file contents */ 
                       long var_num);          /* index of variable struct */

/**********************************/

long QiGetCDFVar(QiCDFVariable *variable, /* pointer to struct for var data */
                long number,             /* var number in cdf & struct array */
                long * time_flag);      /* returns KEEP when time var found */
                
/**********************************/

long QiGetCDFmetadata (QiCDFContents *Scdf_data);  /* ptr to struct for data return */
                  
/**********************************/

CDFstatus QiGetGlobalAttr( long attr_num,  /* attribute number to get */
                           QiGlobalAttribute *g_attr );

/**********************************/

void *QiAttrEntryMalloc( long num_elems,   
                         long data_type );

/**********************************/

long QiGetVariableAttr( long var_num,
                        QiCDFVariable * var);

/**********************************/

long QiStatusHandler (CDFstatus status,     /* status returned from CDFlib */
                      const char *note);          /* message from calling module */

/**********************************/
long QiWriteCSDSgenFlat (QiCDFContents *QiSCDF, /* ptr to struct for data return */
                        QiOptions *QiSOpt);      /* ptr to write options */

/**********************************/

long QiWriteVarObjects(QiCDFContents *QiSCDF, /* ptr to struct for data return */
                      long var_num,              /* index in variable struct  */
                      QiOptions *QiSOpt,         /* ptr to write options object */ 
                      QiRecord_format *QiSfmt,  /* ptr to record format struct */
                      FILE *fp);                 /* ptr to file for data output */

/**********************************/

long QiAttrs_to_Text(QiCDFContents *QiSCDF, /* ptr to struct for data */
                     long var_num,   /* ptr to variable number */
                     FILE *fp,              /* ptr to flat output file */
                     QiOptions *QiSOpt);   /* ptr to structure of write options */

                      
/**********************************/

long QiText_to_Attr( QiCDFContents * QiSCDF,
                     QiOptions * QiSOpt,
                     char * param,
                     char * value,
                     long var_num,
                     long attr_num);
                         
/**********************************/

long QiParseParamValue(char * line, char ** param, char ** value);

                                          
/**********************************/

long QiParseEntry(char delim,
                  char * value,
                  char ** tok);

/**********************************/

long QiParseQuotedEntry(char delim,
                        char * value,
                        char ** tok);

/**********************************/

long QiConfigureRead(QiCDFContents *QiSCDF,   /* ptr to struct of contents */ 
                  QiOptions *QiSOpt,       /* delimiter between table entries */
                  QiRecord_format *QiSfmt); /* ptr to record format structure */

/**********************************/

long QiReadVmeta(QiCDFContents *QiSCDF,   /* ptr to struct of contents */ 
                 QiOptions *QiSOpt,     /* delimiter between table entries */
                 QiRecord_format *QiSfmt); /* ptr to record format structure */

/**********************************/

long QiGetDataType(QiCDFContents *QiSCDF,   /* ptr to struct of contents */ 
                     long * sizeofentry,     /* size of entry in data records */
                     QiOptions *QiSOpt,       /* options */
                     QiRecord_format *QiSfmt, /* ptr to record format struct */
                     long n);               /* variable number */

/**********************************/



long QiReplaceGlobalTxtAttr(QiCDFContents * QiSCDF,
                         const char * attr_name,
                         const char * new_value);

/**********************************/

long QiCreateGlobalTxtAttr(QiCDFContents * QiSCDF,
                           const char * attr_name,
                           const char * new_value);

/**********************************/

long * QiFindGlobalAttr(QiCDFContents * QiSCDF,
                      const char * attr_name,
                      long * attr_num);

/**********************************/

long QiCopyGlobalEntry( QiGAttrEntry * newGentry,
                        QiGAttrEntry * oldGentry,
                        long copy);               /* flag = BY_PTR or BY_MEM */


/**********************************/

long QiAppendGlobalAttr(QiGlobalAttribute * QiSContsAttr,
                       long attr_num,
                       QiGlobalAttribute * QiSInfoAttr );

/**********************************/

long QiCreateGlobalAttr(QiCDFContents * QiSCDF, 
                        QiGlobalAttribute * QiSInfoAttr , 
                        long *n_attr);

/**********************************/

long QiIsNewEntry(QiGlobalAttribute * QiSContsAttr, 
                  QiGAttrEntry * QiSEntry);

/**********************************/

long  QiAddData_type(QiCDFContents * QiSCDF);

/**********************************/

long QiSetEntry( QiGAttrEntry *entry, 
                char * value, 
                long size,
                char delim);

/**********************************/

long QiDataType( char * value,
                 long * sizeofentry);

/**********************************/

long QiReadGlobalFlat( QiCDFContents *QiSCDF,   /* ptr to struct of contents */ 
                       QiOptions *QiSOpt,       /* i/o options */
                       char * attr_name);

/**********************************/

long  QiWriteGlobalFlat(QiCDFContents * QiSCDF, 
                        QiOptions * QiSOpt,             /* i/o options */
                        long attr_num, 
                        FILE *fp);
                        
/**********************************/
                        
long  QiWriteEntry(QiGAttrEntry * entry, 
                   QiOptions *QiSOpt,             /* i/o options */
                   FILE *fp);
                      
/**********************************/

char * QiCDFDataType( long CDF_datatype);  

/**********************************/

size_t CDFsizeof( long data_type, long n_elems);

/**********************************/

long QiReadVarData(QiCDFVariable ** vardata, 
                   long n, 
                   char * value, 
                   long n_items, 
                   QiOptions * QiSOpt);

/**********************************/

int  QiVarExists(QiCDFContents * QiSCDF, const char * name);

/**********************************/ 

  #ifdef   __cplusplus
  }
  #endif
